Rem
Rem $Header: query_georaster.sql 22-jul-2003.16:02:27 qxie Exp $
Rem
Rem query_georaster.sql
Rem
Rem Copyright (c) 2002, 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      query_georaster.sql
Rem
Rem    DESCRIPTION
Rem      use GET functions
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    qxie        07/22/03 - comments
Rem    wexu        11/04/02 - minor changes
Rem    qxie        10/31/02 - qxie_demo1
Rem    qxie        10/28/02 - Created
Rem

set long 20000
set lines 20000
set pages 20000
SET NUMWIDTH 10
SET UNDERLINE =


-------------------------------------------------------------------
-- Query GeoRaster Object Metadata and Ancillary Data
-------------------------------------------------------------------

column georid heading "georId"

-- display the whole metadata document as XML document
--column meta format a100 heading "The Metadata of the GeoRaster object"
--select a.georaster.metadata meta
--  from georaster_table a where georid = 4;


-- query the version of the georaster object
column Version format a20
select georid, sdo_geor.getVersion(georaster) "Version"
  from georaster_table where georid = 4;


-- query the ID of the georaster object
column ID format a10 word_wrapped
select georid, 
       sdo_geor.getID(georaster) ID 
  from georaster_table where georid = 4;


-- query if the georaster object is blank
-- print the cell value if it is blank
column isblank format a10 
select georid,
       sdo_geor.isBlank(georaster) "isBlank",
       sdo_geor.getBlankCellValue(georaster) "blankCellValue"
  from georaster_table
  order by georid;


-- query the default color layers of a true color georaster object
column defaultColorLayers format a30 heading "Default RGB Layers"
select georid, 
       sdo_geor.getDefaultColorLayer(georaster) defaultColorLayers
  from georaster_table where georid = 4;
select georid, 
       sdo_geor.getDefaultRed(georaster) "defaultRedLayer",
       sdo_geor.getDefaultGreen(georaster) "defaultGreenLayer",
       sdo_geor.getDefaultBlue(georaster) "defaultBlueLayer"
  from georaster_table where georid = 4;


-- query the total number of spatial and band dimensions
-- and their sizes which tell the size of the GeoRaster object
column spatialDimSizes format a30 heading "rowSize and columnSize"
select georid, 
       sdo_geor.getSpatialDimNumber(georaster) "totalSpatialDimNumber",
       sdo_geor.getSpatialDimSizes(georaster) spatialDimSizes,
       sdo_geor.getBandDimSize(georaster) "bandSize"
  from georaster_table
  order by georid;


-- query cell depth
select georid, 
       sdo_geor.getCellDepth(georaster) "cellDepth"
  from georaster_table
  order by georid;


-- query the Upper-Left-Top point coordinate
-- as (row, col) if one layer or (row, column, band) if multi-layer
column ULTCoordinate format a30
select georid, 
       sdo_geor.getULTCoordinate(georaster) "ULTCoordinate"
  from georaster_table
  order by georid;


-- query interleaving type
column InterleavingType format a30
select georid, 
       sdo_geor.getInterleavingType(georaster) "InterLeavingType"
  from georaster_table
  order by georid;


-- query cell blocking
column BlockingType format a15
column BlockSizes format a30 heading "BlockSizes(row, col, band)"
select georid, 
       sdo_geor.getBlockingType(georaster) "BlockingType",
       sdo_geor.getBlockSize(georaster) BlockSizes
  from georaster_table
  order by georid;


-- query Spatial Reference System information
column isSpatialReferenced format a10
column isRectified         format a10
column isOrthoRectified    format a10
column resolutions format a40 heading "Spatial Resolutions"
select georid, 
       sdo_geor.isSpatialReferenced(georaster) "isSpatialReferenced",
       sdo_geor.isRectified(georaster) "isRectified",
       sdo_geor.isOrthoRectified(georaster) "isOrthoRectified"
  from georaster_table
  order by georid;
select georid, 
       sdo_geor.getModelSRID(a.georaster) "ModelSRID",
       sdo_geor.getSpatialResolutions(a.georaster) resolutions
  from georaster_table a
  where sdo_geor.isSpatialReferenced(a.georaster) = 'TRUE'
        and georid = 4;


-- for all layer-related get and set functions,
-- layerNumber = 0 means the object layer
-- for subLayers, layerNumber is from 1 ~ n


-- query total layer number. it equals the total band number
select georid, 
       sdo_geor.getTotalLayerNumber(georaster) "TotalLayerNumber"
  from georaster_table
  order by georid;


-- query layer ID which is typically a user-specified unique string
column layer1 format a10 heading "layer1 ID"
column layer2 format a10 heading "layer2 ID"
column layer3 format a10 heading "layer3 ID"
select georid, 
       sdo_geor.getLayerID(georaster, 1) "layer1",
       sdo_geor.getLayerID(georaster, 2) "layer2",
       sdo_geor.getLayerID(georaster, 3) "layer3"
  from georaster_table
  where georid = 4;


-- query scaling function for a specific layer
column scalingFunction format a30
select georid, 
       sdo_geor.getScaling(georaster, 1) "scalingFunction"
  from georaster_table
  where georid = 4;


-- query whether or not the specified layer is (or say, can be 
-- considered as) a grayscale image
column hasGrayScale format a10
select georid, 
       sdo_geor.hasGrayScale(georaster, 1) "hasGrayScale"
  from georaster_table
  order by georid;


-- query whether or not the specified layer is (or say, can be 
-- considered as) a pseudocolor image
column hasPseudoColor format a10
select georid, 
       sdo_geor.hasPseudoColor(georaster, 1) "hasPseudoColor"
  from georaster_table
  order by georid;



-------------------------------------------------------------------
-- Query GeoRaster Object Cell (or say, Raster) Data
-- 
-- Blank GeoRaster object means all its cells have the same value
-------------------------------------------------------------------

-- query a single cell value by specifying cell coordinate
-- in cell space and physical band number
select georid, 
       sdo_geor.getCellValue(georaster, 0, 100, 300, 0)
          "Value of Cell(100,300,0)"
  from georaster_table where georid = 4;


-- query a single cell value by specifying cell coordinate
-- in cell space and logical layer number
select georid, 
       sdo_geor.getCellValue(georaster, 0,
         sdo_geometry(2001,null,null, 
                      mdsys.sdo_elem_info_array(1,1,1),
                      mdsys.sdo_ordinate_array(100,300)), 
         1) "Value of Cell(100,300,0)"
  from georaster_table where georid = 4;



SET UNDERLINE '-'
CLEAR COLUMNS
SET RECSEP OFF
